<?php
defined('BASEPATH') OR exit('No direct script access allowed');   
    
    if(!function_exists('az_select_product_package')){
        function az_select_product_package($id = 'product', $attr='', $parent='idoutlet', $type = 'PACKAGE') {
            $ci =& get_instance();
            $azapp = $ci->load->library('AZApp');
            $select = $ci->azapp->add_select2();
            $select->set_id($id);
            $select->set_select_parent($parent);
            $select->set_url('data_heksa/get_data_product_package');
            $select->set_placeholder(azlang('Select Product'));
            $select->add_param_data('type', $type);
            
            if (strlen($attr) > 0) {
                $select->add_attr('data-id', $ci->encrypt->encode($attr.'.idproduct'));
                $select->add_class('element-top-filter');
                $select->add_attr('data-w', 'true');
            }
            

            return $select->render();
        }
    }

    if(!function_exists('az_select_product_package_customer')){
        function az_select_product_package_customer($id = 'customer_package', $attr='', $parent='idcustomer', $type = 'PACKAGE') {
            $ci =& get_instance();
            $azapp = $ci->load->library('AZApp');
            $select = $ci->azapp->add_select2();
            $select->set_id($id);
            $select->set_select_parent($parent);
            $select->set_url('data_heksa/get_data_product_package_customer');
            $select->set_placeholder(azlang('Select Package'));
            $select->add_param_data('type', $type);
            
            if (strlen($attr) > 0) {
                $select->add_attr('data-id', $ci->encrypt->encode($attr.'.idproduct'));
                $select->add_class('element-top-filter');
                $select->add_attr('data-w', 'true');
            }
            

            return $select->render();
        }
    }

    if(!function_exists('az_update_balance')){
        function az_update_balance($data_balance) {
            $ci =& get_instance();
            $idcustomer_package = azarr($data_balance, 'idbalance');
            $total = azarr($data_balance, 'total');
            $type = azarr($data_balance, 'type');
            $pbalance_name = azarr($data_balance, 'balance_name');
            $balance_description = azarr($data_balance, 'balance_description');            


            $ci->db->where('idbalance', $idcustomer_package);
            $ci->db->order_by('idbalance_history', 'desc');
            $balance_history = $ci->db->get('balance_history', 1);
            if ($balance_history->num_rows() == 0) {
                $ci->db->where('idbalance', $idcustomer_package);
                $last_balance = $ci->db->get('balance')->row()->balance;
                if (strlen($last_balance) == 0) {
                    $last_balance = 0;
                }
            }
            else {
                $last_balance = $balance_history->row()->total_balance;
            }

            // $total = az_crud_number($total);
            if ($type == 'IN') {
                $last_balance = $last_balance + $total;
            }
            else {
                $last_balance = $last_balance - $total;
            }

            $balance_name = 'Penambahan';
            $op = '';
            if ($type == 'OUT') {
                $balance_name = 'Pengurangan';
                $op = '-';
            }
            if (strlen($pbalance_name) > 0) {
                $balance_name = $pbalance_name;
            }

            $arr_balance_history = array(
                'idbalance' => $idcustomer_package,
                'balance_date' => Date('Y-m-d H:i:s'),
                'balance_type' => $type,
                'balance_name' => $balance_name,
                'total' => $op.$total,
                'balance_description' => $balance_description,
                'total_balance' => $last_balance
            );

            $save_balance_history = az_crud_save('', 'balance_history', $arr_balance_history);
            $idbalance_history = azarr($save_balance_history, 'insert_id');

            $arr_code = array(
                'balance_code' => 'SAL-'.sprintf('%03d', $idbalance_history)
            );
            $db = az_crud_save($idbalance_history, 'balance_history', $arr_code);
            $rt_id = azarr($db, 'insert_id');

            $arr_new_balance = array(
                'balance' => $last_balance
            );
            az_crud_save($idcustomer_package, 'balance', $arr_new_balance);
            return $rt_id;
        }
    }