<?php 
	$this->load->helper('az_core');
?>
<!DOCTYPE html>
<html>
<head>
	<title><?php echo azlang('Balance History');?></title>
	<style type="text/css" media="print">
	  @page { size: landscape; }
	</style>

</head>
<body style="font-family: 'Helvetica';font-size:14px;" onload="window.print();">
	<h4 align="center"><?php echo azlang('Balance History');?></h4>
	<h5 align="center">Periode: <?php echo $date1.' s/d '.$date2;?></h5>
	<table style="border-collapse:collapse;" cellpadding="5" cellspacing="3" border="1" width="100%">
		<tr>
			<th>No</td>
			<th><?php echo azlang('Outlet');?></td>
			<th><?php echo azlang('Date');?></td>
			<th><?php echo azlang('Balance Code');?></td>
			<th><?php echo azlang('Customer Name');?></td>
			<th><?php echo azlang('Product');?></td>
			<th><?php echo azlang('Balance Type');?></td>
			<th><?php echo azlang('Description');?></td>
			<th><?php echo azlang('Total');?></td>
			<th><?php echo azlang('Total Balance');?></td>
			<?php 
				if ($show_total) {
			?>
			<th><?php echo azlang('Price');?></td>
			<?php
				}
			?>
		</tr>
		<?php 
			$total = 0;
			foreach ($data->result() as $key => $value) {
				$total += $value->sell_price;
		?>
			<tr>
				<td align="center"><?php echo ($key + 1);?></td> 
				<td><?php echo $value->outlet_name;?></td> 
				<td><?php echo $value->balance_date;?></td> 
				<td><?php echo $value->balance_code;?></td> 
				<td><?php echo $value->customer_name;?></td> 
				<td><?php echo $value->product;?></td> 
				<td><?php echo $value->balance_name;?></td> 
				<td><?php echo $value->balance_description;?></td> 
				<td align="right"><?php echo $value->total;?></td> 
				<td align="right"><?php echo $value->total_balance;?></td>
				<?php 
					if ($show_total) {
				?>
				<td align="right"><?php echo az_thousand_separator($value->sell_price);?></td>
				<?php
					}
				?>
			</tr>
		<?php
			}
		?>
		<?php 
			if ($show_total) {
		?>
		<tr>
			<td colspan="10" align="right">Total</td>
			<td align="right"><?php echo az_thousand_separator($total);?></td>
		</tr>
		<?php
			}
		?>
	</table>
</body>
</html>