CREATE TABLE `balance` (
	`idbalance` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
	`idcustomer` INT(11) NULL DEFAULT NULL,
	`idproduct` INT(11) NULL DEFAULT NULL,
	`balance` DOUBLE NULL DEFAULT NULL,
	`created` DATETIME NULL DEFAULT NULL,
	`createdby` VARCHAR(50) NULL DEFAULT NULL,
	`updated` DATETIME NULL DEFAULT NULL,
	`updatedby` VARCHAR(50) NULL DEFAULT NULL,
	`status` INT(11) NULL DEFAULT '1',
	PRIMARY KEY (`idbalance`),
	INDEX `FK_balance_customer` (`idcustomer`),
	INDEX `FK_balance_customer_2` (`idproduct`),
	CONSTRAINT `FK_balance_customer` FOREIGN KEY (`idcustomer`) REFERENCES `customer` (`idcustomer`),
	CONSTRAINT `FK_balance_customer_2` FOREIGN KEY (`idproduct`) REFERENCES `product` (`idproduct`)
)
COLLATE='latin1_swedish_ci'
ENGINE=InnoDB
;

CREATE TABLE `balance_history` (
	`idbalance_history` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`idbalance` BIGINT(20) UNSIGNED NULL DEFAULT NULL,
	`balance_code` VARCHAR(200) NULL DEFAULT NULL,
	`balance_date` DATETIME NULL DEFAULT NULL,
	`balance_type` VARCHAR(50) NULL DEFAULT NULL,
	`balance_name` VARCHAR(200) NULL DEFAULT NULL,
	`balance_description` VARCHAR(200) NULL DEFAULT NULL,
	`total` DOUBLE NULL DEFAULT NULL,
	`total_balance` DOUBLE NULL DEFAULT NULL,
	`is_void` INT(11) NULL DEFAULT '0',
	`created` DATETIME NULL DEFAULT NULL,
	`createdby` VARCHAR(50) NULL DEFAULT NULL,
	`updated` DATETIME NULL DEFAULT NULL,
	`updatedby` VARCHAR(50) NULL DEFAULT NULL,
	`status` INT(11) NULL DEFAULT '1',
	PRIMARY KEY (`idbalance_history`),
	INDEX `FK_balance_history_balance` (`idbalance`),
	CONSTRAINT `FK_balance_history_balance` FOREIGN KEY (`idbalance`) REFERENCES `balance` (`idbalance`)
)
COLLATE='latin1_swedish_ci'
ENGINE=InnoDB
;

CREATE TABLE `package_transaction` (
	`idpackage_transaction` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
	`idoutlet` INT(11) NULL DEFAULT NULL,
	`idcustomer` INT(11) NULL DEFAULT NULL,
	`idproduct` INT(11) NULL DEFAULT NULL,
	`iduser` INT(11) NULL DEFAULT NULL,
	`transaction_code` VARCHAR(200) NULL DEFAULT NULL,
	`transaction_date` DATETIME NULL DEFAULT NULL,
	`transaction_status` VARCHAR(50) NULL DEFAULT NULL,
	`description` VARCHAR(200) NULL DEFAULT NULL,
	`total` DOUBLE NULL DEFAULT NULL,
	`is_void` INT(11) NULL DEFAULT '0',
	`created` DATETIME NULL DEFAULT NULL,
	`createdby` VARCHAR(50) NULL DEFAULT NULL,
	`updated` DATETIME NULL DEFAULT NULL,
	`updatedby` VARCHAR(50) NULL DEFAULT NULL,
	`status` INT(11) NULL DEFAULT '1',
	PRIMARY KEY (`idpackage_transaction`),
	INDEX `FK_package_transaction_outlet` (`idoutlet`),
	INDEX `FK_package_transaction_customer` (`idcustomer`),
	INDEX `FK_package_transaction_product` (`idproduct`),
	CONSTRAINT `FK_package_transaction_customer` FOREIGN KEY (`idcustomer`) REFERENCES `customer` (`idcustomer`),
	CONSTRAINT `FK_package_transaction_outlet` FOREIGN KEY (`idoutlet`) REFERENCES `outlet` (`idoutlet`),
	CONSTRAINT `FK_package_transaction_product` FOREIGN KEY (`idproduct`) REFERENCES `product` (`idproduct`)
)
COLLATE='latin1_swedish_ci'
ENGINE=InnoDB
;

ALTER TABLE `product`
	ADD COLUMN `quota` DOUBLE NULL DEFAULT NULL AFTER `sell_price`;






