<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Package_transaction extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('package_transaction');
        $this->table = 'package_transaction';
        $this->controller = 'package_transaction';
        $this->load->helper('az_crud');
        $this->load->helper('az_security');
        $this->load->helper('az_app');
    }

	public function index(){
		$this->load->library('AZApp');
		$azapp = $this->azapp;
		$crud = $azapp->add_crud();

		$crud->set_column(array('#', azlang('Outlet'), azlang('Transaction Date'), azlang('Transaction Code'), azlang('Customer'), azlang('Product Package'), azlang('Total (KG)'), azlang('Status'), azlang('Cashier'), azlang('Description'), azlang('Action')));
		$crud->set_id($this->controller);
		$crud->set_default_url(true);


		$date = $azapp->add_datetime();
		$date->set_id('transaction_date_1');
		$date->set_name('transaction_date_1');
		$date->set_format('DD-MM-YYYY');
		$date->set_value('01-'.Date('m-Y'));
		$date->add_class("con-element-top-filter");
		$date = $date->render();
		$data_filter['datetime1'] = $date;

		$date = $azapp->add_datetime();
		$date->set_id('transaction_date_2');
		$date->set_name('transaction_date_2');
		$date->set_format('DD-MM-YYYY');
		$date->set_value(Date('t').'-'.Date('m-Y'));
		$date->add_class("con-element-top-filter");
		$date = $date->render();
		$data_filter['datetime2'] = $date;

		$v_filter = $this->load->view('package_transaction/v_filter_package_transaction', $data_filter, true);
		$crud->set_top_filter($v_filter);

		$v_modal = $this->load->view('package_transaction/v_package_transaction', '', true);
		$crud->set_form('form');
		$crud->set_modal($v_modal);
		$crud->add_btn_right_modal('save-print-trx', azlang('Save & Print'));
		$crud->set_modal_title(azlang("Package Transaction"));
		$v_modal = $crud->generate_modal();


		$v_modal_edit = $this->load->view('package_transaction/v_modal_edit', '', true);
		$modal = $azapp->add_modal();
		$modal->set_modal($v_modal_edit);
		$modal->set_id('edit');
		$modal->set_action_modal(array('save-edit' => azlang('Save')));
		$modal->set_modal_title(azlang("Package Transaction"));
		$modal = $modal->render();

		$azapp->add_content($modal);

		$btn_modal = array(
			'small-invoice' => "<i class='fa fa-print'></i> ".azlang('Small Invoice'),
			'standart-invoice' => "<i class='fa fa-print'></i> ".azlang('Standart Invoice'),
			'send-wa' => "<i class='fa fa-whatsapp'></i> ".azlang("Send Whatsapp")
		);
		$modal_detail = $azapp->add_modal();
		$modal_detail->set_id('detail');
		$modal_detail->set_modal_title(azlang('Detail'));
		$modal_detail->set_modal('');
		$modal_detail->set_action_modal($btn_modal);
		$azapp->add_content($modal_detail->render());

		$this->load->helper('az_core');
		$js = az_add_js('package_transaction/vjs_package_transaction');
		$azapp->add_js($js);

		$vmodal = $this->load->view('package_transaction/v_modal', '', true);
		$modal = $azapp->add_modal();
		$modal->set_id('process');
		$modal->set_modal_title(azlang('Transaction Status'));
		$modal->set_modal($vmodal);
		$modal->set_action_modal(array('save'=>azlang('Save')));
		$azapp->add_content($modal->render());
		
		$crud = $crud->render();
		$crud .= $v_modal;	
		$azapp->add_content($crud);

		$data_header['title'] = azlang('Package Transaction');
		$data_header['breadcrumb'] = array('package_transaction');
		$azapp->set_data_header($data_header);
		
		echo $azapp->render();	
	}

	public function get() {
		$this->load->library('AZApp');
		$crud = $this->azapp->add_crud();
		$crud->set_select('idpackage_transaction, outlet_name, transaction_date, transaction_code, customer_name, concat(product_code, " - ", product_name) as product, total, transaction_status, user.name, package_transaction.description, is_void');
		$crud->set_select_table('idpackage_transaction, outlet_name, transaction_date, transaction_code, customer_name, product, total, transaction_status, user.name, package_transaction.description');
		$crud->set_filter('outlet_name, transaction_date, transaction_code, customer_name, product_code, total, transaction_status, user.name, package_transaction.description');
		$crud->set_sorting('outlet_name, transaction_date, transaction_code, customer_name, product_code, total, transaction_status, user.name, package_transaction.description');
		$idoutlet = $this->session->userdata('idoutlet');
		if (strlen($idoutlet) > 0) {
			$crud->add_where("package_transaction.idoutlet = ".$idoutlet);
		}
		$crud->set_id($this->controller);
		$crud->add_where("package_transaction.status > 0");
		$crud->set_table($this->table);
		$crud->set_order_by('transaction_date desc');
		$crud->add_join('outlet');
		$crud->add_join('customer');
		$crud->add_join('product');
		$crud->add_join('user', 'left');
		$crud->set_select_align(',,,,,right');
		$crud->set_select_decimal('5');
		$crud->set_custom_style('custom_style');
		echo $crud->get_table();
	}

	function custom_style($key, $value, $data) {
		$id = azarr($data, 'idpackage_transaction');
		if ($key == 'transaction_status') {
			switch ($value) {
				case 'NEW':
					$lbl = 'primary';
					break;
				case 'PROGRESS':
					$lbl = 'info';
					break;
				case 'FINISH':
					$lbl = 'warning';
					break;
				case 'ACCEPTED':
					$lbl = 'success';
					break;				
				default:
					$lbl = 'default';
					break;
			}
			return "<label class='label label-".$lbl."'>".azlang($value)."</label>";
		}
		if ($key == 'action') {
			// $btn = "<button class='btn btn-default btn-edit btn-xs' type='button' data-id='".$id."'><i class='fa fa-pencil'></i> ".azlang('Edit')."</button>";	

			$btn = "<button class='btn btn-default btn-detail btn-xs' type='button' data-id='".$id."'><i class='fa fa-list'></i> ".azlang('Detail')."</button>";
			$btn .= "<button class='btn btn-info btn-process btn-xs' type='button' data-id='".$id."'><i class='fa fa-refresh'></i> ".azlang('Process')."</button>";
			// $btn .= "<a href='".app_url().'package_transaction/print_nota/?id='.az_encode_url($id)."' target='_blank'><button class='btn btn-default btn-print-nota btn-xs' type='button'><i class='fa fa-print'></i> ".azlang('Print')."</button></a>";
			$is_void = azarr($data, 'is_void');
			if (!$is_void) {
				$btn .= '<button type="button" class="btn btn-void btn-warning btn-xs" data-id="'.$id.'"><i class="fa fa-remove"></i> Void</button>';
			}
			else {
				$btn .= '<label class="label label-default">Void</label>';
			}
			return $btn;
		}
		return $value;
	}

	public function save(){
		$data = array();
		$data_post = $this->input->post();
		$idpost = azarr($data_post, 'id'.$this->table);
		$data['sMessage'] = '';
		$data['id'] = '';
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('', '');

		$idoutlet = $this->input->post('idoutlet');
		$sess_idoutlet = $this->session->userdata('idoutlet');
		if (strlen($sess_idoutlet) == 0) {
			$this->form_validation->set_rules('idoutlet', azlang('Outlet'), 'required|trim|max_length[200]');
		}
		else {
			$idoutlet = $sess_idoutlet;
		}

		$this->form_validation->set_rules('idcustomer', azlang('Customer'), 'required|trim|max_length[200]');
		$this->form_validation->set_rules('idcustomer_package', azlang('Product Package'), 'required|trim|max_length[200]');
		$this->form_validation->set_rules('total', azlang('Total'), 'required|trim|max_length[200]');

		$err_code = 0;
		$err_message = '';

		if($this->form_validation->run() == FALSE){
			$err_code++;
			$err_message = validation_errors();
		}

		if ($err_code == 0) {
			$total = az_crud_number($this->input->post('total'));
			$idcustomer_package = $this->input->post('idcustomer_package');
			$this->db->where('idbalance', $idcustomer_package);
			$data_product = $this->db->get('balance');
			$idproduct = $data_product->row()->idproduct;
			$last_balance = $data_product->row()->balance;

			if ($last_balance < $total) {
				$err_code++;
				$err_message = azlang('Balance not enough');
			}
		}

		if ($err_code == 0) {
			$data_save = array(
				'idoutlet' => $idoutlet,
				'idcustomer' => $this->input->post('idcustomer'),
				'iduser' => $this->session->userdata('iduser'),
				'idproduct' => $idproduct,
				'total' => $total,
				'transaction_date' => Date('Y-m-d H:i:s'),
				'description' => $this->input->post('description'),
				'transaction_status' => 'NEW'
			);

			$response_save = az_crud_save($idpost, $this->table, $data_save);
			$err_code = azarr($response_save, 'err_code');
			$err_message = azarr($response_save, 'err_message');
			$insert_id = azarr($response_save, 'insert_id');

			$data['id'] = az_encode_url($insert_id);

			$arr_code = array(
				'transaction_code' => 'TRP-'.sprintf('%03d', $insert_id)
			);
			az_crud_save($insert_id, 'package_transaction', $arr_code);

			$post_balance = array(
            	'idbalance' => $idcustomer_package,
            	'total' => $total,
            	'type' => 'OUT',
            	'balance_name' => 'Transaksi',
            	'balance_description' => 'Transaksi '.$arr_code['transaction_code'],
            );
            az_update_balance($post_balance);
		}

		$data["sMessage"] = $err_message;
		echo json_encode($data);
	}

	public function edit() {
		$this->db->join('outlet', 'outlet.idoutlet = package_transaction.idoutlet');
		az_crud_edit('idpackage_transaction, package_transaction.idoutlet, package_transaction_code, package_transaction_name, package_transaction_type, sell_price, validity_period, quota, description');
	}

	function save_process() {
		$id = $this->input->post('id');
		$type = $this->input->post('type');
		$description = $this->input->post('edit_description');

		$arr_update = array(
			'transaction_status' => $type,
			'description' => $description
		);
		
		$this->db->where('idpackage_transaction', $id);
		$this->db->update('package_transaction', $arr_update);

		$ret = array(
			'err_code' => 0
		);
		echo json_encode($ret);
	}

	function print_nota($the_id = '') {
		$id = $this->input->get('id');
		$id = az_decode_url($id);

		if (strlen($the_id) > 0) {
			$id = $the_id;
		}

		$this->db->select('outlet_name, outlet.address as outlet_address, transaction_code, outlet.phone as outlet_phone, transaction_date, package_transaction.idcustomer, customer_name, product_name, total, transaction_status, package_transaction.description as transaction_description');
		$this->db->where('idpackage_transaction', $id);
		$this->db->join('outlet', 'package_transaction.idoutlet = outlet.idoutlet');
		$this->db->join('customer', 'package_transaction.idcustomer = customer.idcustomer');
		$this->db->join('product', 'package_transaction.idproduct = product.idproduct');
		$data = $this->db->get('package_transaction');
		
		if ($data->num_rows() > 0) {
			$the = azarr($data->result_array(), 0);
			$param['data'] = $the;

			// $this->db->where('balance_name', 'Transaksi');
			// $this->db->where('balance_type', 'OUT');
			// $this->db->where('balance_description', 'Transaksi '.$the['transaction_code']);
			// $this->db->join('balance', 'balance_history.idbalance = balance.idbalance');
			// $db_balance = $this->db->get('balance_history');
			// $total_balance = $db_balance->row()->total_balance;
			// $param['balance'] = $total_balance;

			$this->db->where('balance.status', 1);
			$this->db->where('balance.idcustomer', $data->row()->idcustomer);
			$this->db->join('product', 'balance.idproduct = product.idproduct');
			$this->db->join('customer', 'balance.idcustomer = customer.idcustomer');
			$this->db->select('concat(product_code," - ", product_name) as product, balance as balance_ori, concat(balance, " KG") as balance');
			$param['balance'] = $this->db->get('balance');

			$this->load->view('package_transaction/v_nota', $param);
		}
	}

	function void() {
		$id = $this->input->post('id');
		$arr_void = array(
			'is_void' => 1
		);
		$this->db->where('idpackage_transaction', $id);
		$this->db->update('package_transaction', $arr_void);


		$this->db->where('idpackage_transaction', $id);
		$data = $this->db->get('package_transaction');

		$idcustomer = $data->row()->idcustomer;
		$idproduct = $data->row()->idproduct;
		$this->db->where('idcustomer', $idcustomer);
		$this->db->where('idproduct', $idproduct);
		$balance = $this->db->get('balance');

		$post_balance = array(
        	'idbalance' => $balance->row()->idbalance,
        	'total' => $data->row()->total,
        	'type' => 'IN',
        	'balance_name' => 'VOID Transaksi',
        	'balance_description' => 'VOID Transaksi '.$data->row()->transaction_code,
        );
        az_update_balance($post_balance);


		echo json_encode(array('ok'=>'ok'));
	}

	function get_edit() {
		$id = $this->input->post('id');
		$this->db->select('idpackage_transaction, description, transaction_status');
		$this->db->where('idpackage_transaction', $id);
		$data = $this->db->get('package_transaction');
		$rdata = azarr($data->result_array(), 0);

		echo json_encode($rdata);
	}

	function save_edit() {
		$id = $this->input->post('edit_idpackage_transaction');
		$description = $this->input->post('edit_description');
		$arr = array(
			'description' => $description
		);

		$this->db->where('idpackage_transaction', $id);
		$this->db->update('package_transaction', $arr);

		echo json_encode(array('ok' => 'ok'));
	}

	public function delete() {
		
	}

	function get_invoice($the_id = '') {
		$this->load->helper('az_core');
		$id = $this->input->post('id');
		if (strlen($the_id) > 0) {
			$id = $the_id;
		}
		// $id = 8;

		$this->db->where('idpackage_transaction', $id);
		$this->db->where('package_transaction.status', 1);
		$this->db->join('product', 'package_transaction.idproduct = product.idproduct');
		$this->db->join('customer', 'package_transaction.idcustomer = customer.idcustomer');
		$the_data = $this->db->get('package_transaction');
		$rdata = $the_data->result_array();
		$rdata = azarr($rdata, 0);

		$data['data'] = $rdata;

		$this->db->where('idoutlet', $the_data->row()->idoutlet);
		$data_outlet = $this->db->get('outlet')->result_array();
		$data_outlet = azarr($data_outlet, 0);
		$data['outlet'] = $data_outlet;

		$this->db->where('balance.status', 1);
		$this->db->where('balance.idcustomer', $the_data->row()->idcustomer);
		$this->db->join('product', 'balance.idproduct = product.idproduct');
		$this->db->join('customer', 'balance.idcustomer = customer.idcustomer');
		$this->db->select('concat(product_code," - ", product_name) as product, balance as balance_ori, concat(balance, " KG") as balance');
		$data['balance'] = $this->db->get('balance');

		$this->load->helper('az_config');

		if (strlen($the_id) > 0) {
			$this->load->view('package_transaction/v_invoice', $data);
		}
		else {
			$view = $this->load->view('package_transaction/v_invoice', $data, true);

			$return = array(
				'data' => $view
			);

			echo json_encode($return);
		}

	}

	function invoice() {
		$code = $this->input->get('c');
		$type = $this->input->get('t');
		$code = urldecode($code);
		
		$this->load->helper('az_config');
		if ($type == 'small') {
			$this->print_nota($code);
		}
		else {
			$this->get_invoice($code);
		}
	}
}