<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends AZ_Controller {
	public function __construct() {
        parent::__construct();
        $this->load->helper('az_auth');
        $this->load->helper('az_config');
        az_check_auth('dashboard');
    }

	public function index(){
		$this->load->library('AZApp');
		$app = $this->azapp;
		$data_header['title'] = azlang('Dashboard');
		$data_header['breadcrumb'] = array('dashboard');
		$app->set_data_header($data_header);

		$this->load->helper('az_core');
		$js = az_add_js('home/vjs_home');
		$app->add_js($js);

		$idoutlet = $this->session->userdata('idoutlet');
		if (strlen($idoutlet) > 0) {
			$this->db->where('transaction_group.idoutlet', $idoutlet);
		}
		$this->db->group_by('transaction_group_status');
		$this->db->where('date(date)', Date('Y-m-d'));
		$this->db->select('transaction_group_status, count(grand_total_final) as total');
		$this->db->where('status', 1);
		$tg = $this->db->get('transaction_group');

		$data['NEW'] = 0;
		$data['PROGRESS'] = 0;
		$data['FINISH'] = 0;
		$data['ACCEPTED'] = 0;
		foreach ($tg->result() as $key => $value) {
			$data[$value->transaction_group_status] = $value->total;
		}

		$this->db->where('status', 1);
		$this->db->where('is_void', 0);
		$this->db->where("transaction_date", Date('Y-m-d'));
		$package = $this->db->get('package_transaction');
		foreach ($package->result() as $key => $value) {
			$data[$value->transaction_status] += 1;
		}

		$view = $this->load->view('home/v_home', $data, true);
		$app->add_content($view);
		echo $app->render();	
	}

	function repair(){
		$this->db->where('idoutlet', 17);
		$this->db->where('idtransaction_group > ', 260);
		$data = $this->db->get('transaction_group');

		$no = 42;
		$ret = '';
		foreach ($data->result() as $key => $value) {
			$no++;
			$new_no = sprintf('%04d', $no);
			$ret .= "update transaction_group set code = '2018/06/JL2/".$new_no."' where idtransaction_group = ".$value->idtransaction_group.';';
			$ret .= '<br>';
		}

		echo $ret;
	}


	function supri() {
		ini_set('max_execution_time', 30000000000);
		$this->load->library('AZApp');
		$azapp = $this->azapp;	
		$azapp->add_phpexcel();
		$inputFileType = 'CSV';
		$inputFileName = APPPATH.'assets/supri/supri_csv.csv';
		$objReader = PHPExcel_IOFactory::createReader($inputFileType);
		$objPHPExcel = $objReader->load($inputFileName);
		$worksheet = $objPHPExcel->getActiveSheet();
		$j = 0;
		$arr_data = array();
		foreach ($worksheet->getRowIterator() as $row) {
		    // echo 'Row number: ' . $row->getRowIndex() . "\r\n";

		    $cellIterator = $row->getCellIterator();
		    $cellIterator->setIterateOnlyExistingCells(false); // Loop all cells, even if it is not set
		    $i = 0;
		    $the_arr = array();
		    foreach ($cellIterator as $cell) {
		        if (!is_null($cell)) {
		            // echo 'Cell: ' . $cell->getCoordinate() . ' - ' . $cell->getValue() . "\r\n";
		            $data = $cell->getValue();
		            if ($i == 0) {
		            	$arr_data[$j]['nomor'] = $data;
		            	$the_arr['nomor'] = $data;
		            }
		            else if ($i == 1) {
		            	$arr_data[$j]['no_gambar'] = $data;
		            	$the_arr['no_gambar'] = $data;
		            }
		            else if ($i == 2) {
		            	$arr_data[$j]['nim'] = $data;
		            	$the_arr['nim'] = $data;
		            }
		            else if ($i == 3) {
		            	$arr_data[$j]['nama'] = $data;
		            	$the_arr['nama'] = $data;
		            }
		            else if ($i == 4) {
		            	$arr_data[$j]['tempat_lahir'] = $data;
		            	$the_arr['tempat_lahir'] = $data;
		            }
		            else if ($i == 5) {
		            	$data = str_replace('/', '-', $data);
		            	$data = str_replace(' ', '', $data);
		            	$data = str_replace("'", '', $data);
		            	$tdata = explode('-', $data);
		            	$tridata = azarr($tdata, 2);
		            	if (strlen($tridata) == 2) {
		            		$data = $tdata[0].'-'.$tdata[1].'-19'.$tdata[2];
		            	}
		            	$the_date = Date('Y-m-d', strtotime($data));
		            	if ($the_date == '1970-01-01') {
		            		$the_date = NULL;
		            	}
		            	$arr_data[$j]['tanggal_lahir'] = $the_date;
		            	$the_arr['tanggal_lahir'] = $the_date;
		            }
		            else if ($i == 6) {
		            	$data = str_replace('/', '-', $data);
		            	$data = str_replace(' ', '', $data);
		            	$data = str_replace("'", '', $data);
		            	$tdata = explode('-', $data);
		            	$tridata = azarr($tdata, 2);
		            	if (strlen($tridata) == 2) {
		            		$data = $tdata[0].'-'.$tdata[1].'-19'.$tdata[2];
		            	}
		            	$the_date = Date('Y-m-d', strtotime($data));
		            	if ($the_date == '1970-01-01') {
		            		$the_date = NULL;
		            	}
		            	$arr_data[$j]['tanggal_ijazah'] = $the_date;
		            	$the_arr['tanggal_ijazah'] = $the_date;
		            }
		            else if ($i == 7) {
		            	$arr_data[$j]['no_ijazah'] = $data;
		            	$the_arr['no_ijazah'] = $data;
		            }
		        }
		    	$i++;
		    }
		    $j++;
		    $this->db->insert('supri', $the_arr);
		}
		
	}

	function suprix() {
		$this->load->library('AZApp');
		$azapp = $this->azapp;	
		$azapp->add_phpexcel();
		$file = APPPATH.'assets/supri/supri_csv.csv';
        $objPHPExcel = PHPExcel_IOFactory::load($file);
        $sheet0 = $objPHPExcel->setActiveSheetIndex(0);	
	    
        $i = 1;
    	do {
        	$a = 'A';
        	$data = $sheet0->getCell($a.$i)->getValue(); $a++; 

        	$i++;

    		if (strlen($data) == 0) {
    			continue;
    		}

    		$xdata = explode(":", $data);
			
			$nomor = azarr($xdata, 0);
			$no_gambar = azarr($xdata, 1);
			$nim = azarr($xdata, 2);
			$nama = azarr($xdata, 3);
			$tempat_lahir = azarr($xdata, 4);
			$tanggal_lahir = azarr($xdata, 5);
			$tanggal_ijazah = azarr($xdata, 6);
			$no_ijazah = azarr($xdata, 7);



			// $tanggal_lahir = str_replace('/', '-', $tanggal_lahir);
			// $tanggal_lahir = Date('Y-m-d', strtotime($tanggal_lahir));

			// $tanggal_ijazah = str_replace('/', '-', $tanggal_ijazah);
			// $tanggal_ijazah = Date('Y-m-d', strtotime($tanggal_ijazah));

			$arr_data = array(
				'nomor' => $nomor,
				'no_gambar' => $no_gambar,
				'nim' => $nim,
				'nama' => $nama,
				'tempat_lahir' => $tempat_lahir,
				'tanggal_lahir' => $tanggal_lahir,
				'tanggal_ijazah' => $tanggal_ijazah,
				'no_ijazah' => $no_ijazah,
			);
			echo '<pre>';
			print_r($data);
    		echo '<br>';
    	} while (strlen($data) > 0);
	}

}