<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Data_heksa extends CI_Controller {
	public function __construct() {
        parent::__construct();
    }

    public function get_data_product_package(){
		$limit = 20;
		$q = $this->input->get("term");
		$page = $this->input->get("page");
		$parent = $this->input->get("parent");
		$type = $this->input->get('type');

		$offset = ($page - 1) * $limit;

		$this->db->where('idoutlet', $parent);
		$this->db->order_by("product_name");
		$this->db->where('product_type', $type);
		if (strlen($q) > 0) {
			$this->db->like("product_name", $q);
		}
		$this->db->select("idproduct as id, concat(product_code, ' - ',product_name, ' - Rp ', convert(FORMAT(sell_price, 0) using utf8), ' - ', quota, ' KG') as text");
		$this->db->where('status', '1');

		$data = $this->db->get("product", $limit, $offset);

		$this->db->where('idoutlet', $parent);
		$this->db->where('product_type', $type);
		if (strlen($q) > 0) {
			$this->db->like("product_name", $q);
		}
		$this->db->where('status', '1');
		$cdata = $this->db->get("product");
		$count = $cdata->num_rows();

		$endCount = $offset + $limit;
		$morePages = $endCount < $count;

		$results = array(
		  "results" => $data->result_array(),
		  "pagination" => array(
		  	"more" => $morePages
		  )
		);
		echo json_encode($results);
	}

	public function get_data_product_package_customer(){
		$limit = 20;
		$q = $this->input->get("term");
		$page = $this->input->get("page");
		$parent = $this->input->get("parent");
		$type = $this->input->get('type');

		$offset = ($page - 1) * $limit;

		$this->db->where('idcustomer', $parent);
		$this->db->where('balance !=', 0);
		$this->db->order_by("product_name");
		$this->db->where('product_type', $type);
		if (strlen($q) > 0) {
			$this->db->like("product_name", $q);
		}
		$this->db->select("balance.idbalance as id, concat(product_code, ' - ',product_name, ' - Rp ', convert(FORMAT(sell_price, 0) using utf8), ' [', balance,'KG]') as text");
		$this->db->join('product', 'balance.idproduct = product.idproduct');
		$this->db->where('balance.status', '1');
		// $this->db->where('date_end > ', Date('Y-m-d'));
		$this->db->order_by('product_name');

		$data = $this->db->get("balance", $limit, $offset);

		$this->db->where('idcustomer', $parent);
		$this->db->where('balance !=', 0);
		$this->db->where('product_type', $type);
		if (strlen($q) > 0) {
			$this->db->like("product_name", $q);
		}
		$this->db->join('product', 'balance.idproduct = product.idproduct');
		$this->db->where('balance.status', '1');
		// $this->db->where('date_end > ', Date('Y-m-d'));
		$cdata = $this->db->get("balance");
		$count = $cdata->num_rows();

		$endCount = $offset + $limit;
		$morePages = $endCount < $count;

		$results = array(
		  "results" => $data->result_array(),
		  "pagination" => array(
		  	"more" => $morePages
		  )
		);
		echo json_encode($results);
	}
}